import smtplib
from jinja2 import Template
from email.mime.text import MIMEText
from email.mime.multipart import MIMEMultipart

#send an HTML email using the built-in template
def send_lead(bob, summary, name, email, phone, whatsapp, platform, transcript):

    SMTP_PORT = bob['Email']['smtp_port']
    SMTP_SERVER = bob['Email']['smtp_server']
    SMTP_USERNAME = bob['Email']['smtp_username']
    SMTP_PASSWORD = bob['Email']['smtp_password']
    SMTP_TO_EMAIL = bob['Email']['client_email']
    SMTP_FROM_EMAIL = bob['Email']['bob_email']
    SMTP_AGENT_NAME = bob['ID']['name']
    BOB_NAME = bob['ID']['name']
    
    #SUBJECT
    subject = SMTP_AGENT_NAME + " just spoke to " + name + " on " + platform
    
    # HTML Template
    with open('email_templates/lead-email.html', 'r') as file:
        html_template = file.read()

    # Create message container
    msg = MIMEMultipart('alternative')
    msg['Subject'] = subject
    msg['From'] = SMTP_FROM_EMAIL
    msg['To'] = SMTP_TO_EMAIL

    # Render the HTML template
    template = Template(html_template)
    html_content = template.render(subject=subject,
                                   summary=summary,
                                   name=name,
                                   email=email,
                                   phone=phone,
                                   whatsapp=whatsapp,
                                   platform=platform,
                                   transcript=transcript,
                                    bobname=BOB_NAME)

    # Attach HTML content
    msg.attach(MIMEText(html_content, 'html'))

    try:
        server = smtplib.SMTP(SMTP_SERVER, SMTP_PORT)
        server.starttls()
        server.login(SMTP_USERNAME, SMTP_PASSWORD)

        # Send email
        server.sendmail(SMTP_FROM_EMAIL, SMTP_TO_EMAIL, msg.as_string())
        server.quit()
        return {"success": True, "message": "Email sent successfully"}
    except Exception as e:
        print(f"ERROR: Failed to send email: {str(e)}")
        return {"success": False, "error": str(e)}




#send an HTML email using the built-in template
def send_report(bob, no_leads, no_convs, leads_summary, conv_summary):

    SMTP_PORT = bob['Email']['smtp_port']
    SMTP_SERVER = bob['Email']['smtp_server']
    SMTP_USERNAME = bob['Email']['smtp_username']
    SMTP_PASSWORD = bob['Email']['smtp_password']
    SMTP_TO_EMAIL = bob['Email']['client_email']
    SMTP_FROM_EMAIL = bob['Email']['bob_email']
    SMTP_AGENT_NAME = bob['ID']['name']
    BOB_NAME = bob['ID']['name']

    #SUBJECT
    subject = SMTP_AGENT_NAME + " processed " + str(no_convs) + " conversations and " + str(no_leads) + " leads"


    # HTML Template
    with open('email_templates/report-email.html', 'r') as file:
        html_template = file.read()

    # Create message container
    msg = MIMEMultipart('alternative')
    msg['Subject'] = subject
    msg['From'] = SMTP_FROM_EMAIL
    msg['To'] = SMTP_TO_EMAIL

    # Render the HTML template
    template = Template(html_template)
    html_content = template.render(subject=subject,
                                   leads_summary=leads_summary,
                                   conv_summary=conv_summary,
                                    bobname=BOB_NAME)

    # Attach HTML content
    msg.attach(MIMEText(html_content, 'html'))

    try:
        server = smtplib.SMTP(SMTP_SERVER, SMTP_PORT)
        server.starttls()
        server.login(SMTP_USERNAME, SMTP_PASSWORD)

        # Send email
        server.sendmail(SMTP_FROM_EMAIL, SMTP_TO_EMAIL, msg.as_string())
        server.quit()
        return {"success": True, "message": "Email sent successfully"}
    except Exception as e:
        print(f"ERROR: Failed to send email: {str(e)}")
        return {"success": False, "error": str(e)}
