#!/bin/bash
echo "=== Autocolant APP Status ==="

# Check if process is running
if pgrep -f "python main.py" > /dev/null; then
    echo "✅ API process is running"
    echo "Process ID: $(pgrep -f "python main.py")"
else
    echo "❌ API process not found"
fi

# Test API response
echo ""
echo "Testing API endpoint..."
if curl -s -X POST https://autocolant.serban.eu.com/delay -H "Content-Type: application/json" -d '{}' | grep -q "ManyChat"; then
    echo "✅ API is responding correctly"
else
    echo "❌ API not responding or error"
fi

echo ""
echo "Recent log entries:"
echo "==================="
tail -5 public_html/flask.log
